#version 130
#extension GL_EXT_gpu_shader4 : enable
// the version and open GL extension
// should be the first line of the shader
/////////////////////////////////////////////////////////////////////////////////
//how to render a black hole -p2Mod01.fsh  by  feefi  
//https://www.shadertoy.com/view/WltSDM
// Licence CC0
// Adapted, trivialy, for use in VGHD player
/////////////////////////////////////////////
uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels

#define iTime u_Elapsed*0.314159  //*0.1666
#define iResolution u_WindowSize

//#define mouse AUTO_MOUSE
//#define MOUSE_SPEED vec2(vec2(0.5,0.577777) * 0.25)
//#define MOUSE_POS   vec2((1.0+cos(iTime*MOUSE_SPEED))*u_WindowSize/2.0)
//#define MOUSE_PRESS vec2(0.0,0.0)
//#define AUTO_MOUSE  vec4( MOUSE_POS, MOUSE_PRESS )
//#define RIGID_SCROLL
// alternatively use static mouse definition
#define iMouse vec4(0.0,0.0, 0.0,0.0)
//#define iMouse vec4(512,256,180,120)
uniform sampler2D iChannel0;
uniform sampler2D iChannel1;
uniform sampler2D iChannel2;
uniform sampler2D iChannel3;
vec4 texture2D_Fract(sampler2D sampler,vec2 P) {return texture2D(sampler,fract(P));}
vec4 texture2D_Fract(sampler2D sampler,vec2 P, float Bias) {return texture2D(sampler,fract(P),Bias);}
#define texture2D texture2D_Fract


vec3 black_hole_pos = vec3(0.0,0,1.5); 		//黑洞的位置
float event_horizon_radius = 0.3;		//黑洞的事件视界半径
float HitTest(vec3 p){
	return length(p) - event_horizon_radius;
}
vec3 GetBg(vec3 p)
{
    return smoothstep(vec3(0),vec3(1.),fract(p*1.));
}

//void mainImage( out vec4 fragColor, in vec2 fragCoord )
///////////////////////////////////////////////////////////////////////////////// 
// need to convert this from a void to a function and call it by adding
// a void main(void) { to the end of the shader
// what type of variable will the function return?, it is a color and needs to be a vec4
// change void to vec4 
//void MainImage(out vec4 fragColor, in vec2 fragCoord) 
vec4 mainImage( out vec4 fragColor, in vec2 fragCoord )
{
    //映射到0~1之间
    vec2 uv = fragCoord/iResolution.xy;
    uv = uv*2.  - 1.;	
    uv.x *= iResolution.x / iResolution.y;	
	vec3 eye = vec3(0.,0.,-2);    //eye or camera postion 相机位置
    vec3 sd = vec3(uv.x,uv.y,-1); //screen coord 屏幕坐标
    vec3 ray_dir = normalize( sd - eye);//ray direction 射线方向
    
    vec3 col = vec3(0.);
    
	float hitbh = 0.;
    
    const int maxStep = 400;//光线最大步进数
    float st = 0.;      
    vec3 p = sd;
    vec3 v = ray_dir;
    float dt = 0.01;
    float GM = 0.8;   
    vec3 cp = black_hole_pos + 2.*vec3(1.5*sin(iTime),sin(1.31*iTime),0.);
    for(int i = 0;i<maxStep;++i)
    {
       	//F = G * M * m / r^2;
    	//a = F/m
    	//v = v + a * dt;
    	//p = p + v * dt;
        p += v * dt;
        vec3 relP = p - cp; //黑洞相对原点的位置       
        float r2 = dot(relP,relP);
        vec3 a = GM/r2 * normalize(-relP); //加速度的方向朝向黑洞，为-relP
        v += a * dt;        
        float hit = HitTest(relP); //hit表示距物体的最小距离
		hitbh = step(hit,0.);   
        if(hitbh > 0.5)break;
    }
    col = GetBg(p)*(1.-hitbh);
    fragColor = vec4(col,1.0);
/////////////////////////////////////////////////////////////////////////////////
//the function needs to return a value. 
//it needs to be a vec4
//we will return the varable fragColor 
// usual place for fragColor = vec4( color, 1.0 ); bring the } down below
return fragColor; 
}

///////////////////////////////////////////////////////////////////////////////// 
void main(void) { // this will be run for every pixel of gl_FragCoord.xy
vec4 fragColor = vec4(1.0); // initialize variable fragColor as a vec4 
vec4 cc = mainImage(fragColor, gl_FragCoord.xy); // call function mainImage and assign the return vec4 to cc
gl_FragColor = vec4(cc) * gl_Color; // set the pixel to the value of vec4 cc  and..
}

// ..uses the values of any Color: or Opacity:
// clauses (and any Animate clauses applied to these properties) 
// appearing in the Sprite, Quad or other node invoking the shader 
// in the .scn file.

